% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AbSeqCRep.R
\docType{methods}
\name{+,AbSeqCRep,AbSeqCRep-method}
\alias{+,AbSeqCRep,AbSeqCRep-method}
\title{Combines 2 \linkS4class{AbSeqCRep} objects together for comparison}
\usage{
\S4method{+}{AbSeqCRep,AbSeqCRep}(e1, e2)
}
\arguments{
\item{e1}{AbSeqCRep.}

\item{e2}{AbSeqCRep.}
}
\value{
\linkS4class{AbSeqCRep} object. Calling \code{abseqR}'s
functions on this object will always result in a comparison.
}
\description{
Combines 2 \linkS4class{AbSeqCRep} objects together for comparison
}
\examples{
# Use example data from abseqR as abseqPy's output, substitute this
# with your own abseqPy output directory
abseqPyOutput <- tempdir()
file.copy(system.file("extdata", "ex", package = "abseqR"), abseqPyOutput, recursive=TRUE)
samples <- abseqReport(file.path(abseqPyOutput, "ex"), report = 0)

# The provided example data has PCR1, PCR2, and PCR3 samples contained within
# pcr12 and pcr13 are instances of AbSeqCRep
pcr12 <- samples[["PCR1"]] + samples[["PCR2"]]
pcr13 <- samples[["PCR1"]] + samples[["PCR3"]]

# all_S is also an instance of AbSeqCRep
all_S <- pcr12 + pcr13

# you can now call the report function on this object
# report(all_S)           # uncomment this line to execute report
}
\seealso{
\code{\link{abseqReport}} returns a \code{list} of \code{AbSeqRep}s
}
