% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/upstreamAnalysis.R
\name{.plotIGVUpstreamLenDistDetailed}
\alias{.plotIGVUpstreamLenDistDetailed}
\title{Plots the detailed length distribution for IGV families}
\usage{
.plotIGVUpstreamLenDistDetailed(upstreamDirectories, upstreamOut,
  upstreamLengthRange, lengthType, sampleNames, combinedNames, mashedNames,
  .save = TRUE)
}
\arguments{
\item{upstreamDirectories}{list type. List of sample directories}

\item{upstreamOut}{string type. Output directory}

\item{upstreamLengthRange}{The range of upstream sequences to be included in
this plot. This is usually determined by abseqPy and the format should be as
follows: "min_max", e.g.: 1_15 means range(1, 15) inclusive.string type.}

\item{lengthType}{string type. "" (the empty string) denotes everything
and "_short" denotes a short sequence. abseqPy dictates this because it's
used for locating the files.}

\item{sampleNames}{vector type. 1-1 with upstream directories}

\item{combinedNames}{string type. Title friendly "combined" sample names}

\item{mashedNames}{string type. File friendly "mashed-up" sample names}

\item{.save}{logical type. Save Rdata?}
}
\value{
None
}
\description{
A boxplot for each IGV families showing the IQR of upstream
lengths. In contrast to \code{\link{.plotIGVUpstreamLenDist}},
which only shows the distribution of IGV families
over \code{upstreamLengthRange}.
}
