% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spectralMap.R
\docType{methods}
\name{spectralMap-methods}
\alias{spectralMap-methods}
\alias{spectralMap,ExpressionSet,character}
\alias{volcanoPlot,ExpressionSet,character}
\alias{spectralMap,ExpressionSet,character-method}
\title{Methods for Function spectralMap according to JnJ Standards}
\usage{
\S4method{spectralMap}{ExpressionSet,character}(
  object,
  groups,
  makeLognormal = TRUE,
  mpm.args = list(row.weight = "mean", col.weight = "constant", logtrans = TRUE),
  plot.mpm.args = list(zoom = c(1, 2), label.tol = 10, rot = c(-1, 1), sub = "",
    lab.size = 0.85, col.group = pData(object)[, groups], colors = c("wheat", "darkgrey",
    a4palette(nlevels(pData(object)[, groups]))), col.size = 2, do.smoothScatter = TRUE),
  probe2gene = TRUE,
  addLegend = TRUE,
  legendPos = "topleft",
  ...
)
}
\arguments{
\item{object}{object of class ExpressionSet}

\item{groups}{string indicating the name of the column in the phenoData that
defines the groups}

\item{makeLognormal}{boolean indicating whether one wants to exponentiate the
    data to make them lognormally shaped (\code{TRUE}; the default) or not 
(\code{FALSE})}

\item{mpm.args}{list of arguments that can be passed to the \code{mpm} function}

\item{plot.mpm.args}{list of arguments that can be passed to the 
\code{plot.mpm} function that actually draws the plot}

\item{probe2gene}{boolean indicating whether one wants to display the gene symbols
for the labeled points (\code{TRUE}) or not (\code{FALSE}; the default)}

\item{addLegend}{Boolean indicating whether a legend for the colors of the dots should be added.}

\item{legendPos}{Specify where the legend should be placed. Typically either \code{topright},}

\item{...}{further arguments to be passed to the methods,
currently not used.}
}
\value{
the plot is returned invisibly
}
\description{
Methods for spectralMap
}
\author{
Tobias Verbeke
}
\keyword{hplot}
\keyword{methods}
