% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{exposures_barplot}
\alias{exposures_barplot}
\title{Wrapper for enhanced_barplot}
\usage{
exposures_barplot(
  in_exposures_df,
  in_signatures_ind_df = NULL,
  in_subgroups_df = NULL,
  in_sum_ind = NULL,
  in_subgroups.field = "subgroup",
  in_title = "",
  in_labels = TRUE,
  in_show_subgroups = TRUE,
  ylab = NULL,
  in_barplot_borders = TRUE,
  in_column_anno_borders = FALSE
)
}
\arguments{
\item{in_exposures_df}{Numerical data frame encoding the exposures \code{H},
i.e. which signature contributes how much to which PID (patient identifier
or sample).}

\item{in_signatures_ind_df}{A data frame containing meta information about
the signatures. If NULL, the colour information for the signatures is 
taken from a rainbow palette.}

\item{in_subgroups_df}{A data frame indicating which PID (patient or sample
identifyier) belongs to which subgroup. If NULL, it is assumed that all
PIDs belong to one common subgroup. The colour coding for the default
subgroup is red.}

\item{in_sum_ind}{Index vector influencing the order in which the PIDs are
going to be displayed}

\item{in_subgroups.field}{String indicating the column name in
\code{in_subgroups_df} to take the subgroup information from.}

\item{in_title}{Title for the plot to be created.}

\item{in_labels}{Flag, if \code{TRUE} the PIDs are displayed on the x-axis}

\item{in_show_subgroups}{Flag, if \code{TRUE} then PIDs are grouped by
subgroups}

\item{ylab}{Label of the y-axis on the plot to be generate}

\item{in_barplot_borders}{Whether or not to show border lines in barplot}

\item{in_column_anno_borders}{Whether or not to draw separating lines 
between the fields in the annotation}
}
\value{
The generated barplot - a ggplot2 plot
}
\description{
Wrapper for enhanced_barplot
}
\examples{
 data(lymphoma_cohort_LCD_results)
 exposures_barplot(lymphoma_Nature2013_COSMIC_cutoff_exposures_df,
                   chosen_signatures_indices_df,
                   COSMIC_subgroups_df)

}
