% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indel_functions.R
\name{create_indel_mutation_catalogue_from_df}
\alias{create_indel_mutation_catalogue_from_df}
\title{Wrapper to create an INDEL mutational catalog from a vlf-like data frame}
\usage{
create_indel_mutation_catalogue_from_df(
  in_dat,
  in_signature_df,
  in_REF.field = "REF",
  in_ALT.field = "ALT",
  in_verbose = FALSE
)
}
\arguments{
\item{in_dat}{A data frame constructed from a vcf-like file of a whole cohort
or single-sample. The first columns are those of a standard vcf file
(\code{CHROM}, \code{POS}, \code{REF} and \code{ALT}), followed by an
arbitrary number of custom or used defined columns. One of these can carry
a PID (patient or sample identifyier) and one can carry subgroup
information.}

\item{in_signature_df}{A numeric data frame \code{W} with \code{n} rows and
\code{l} columns, n being the number of features and l being the number od
signatures. Data frame containing INDEL signatures which should be used to
create the mutational cataologe \code{V}.}

\item{in_REF.field}{String indicating which column of \code{in_dat} carries
the reference base if dealing with data frames}

\item{in_ALT.field}{String indicating which column of \code{in_dat} carries
the variant base if dealing with data frames}

\item{in_verbose}{Verbose if \code{in_verbose=1}}
}
\value{
A dataframe in the format of a mutational catalog \code{V}, which can
be used for \code{\link[YAPSA]{LCD}} analysis
}
\description{
From data frame constucted from a vcf-file file the function
\code{\link[YAPSA]{create_indel_mutation_catalogue_from_df}} creates a
mutational catalog V by squencially applying the
\code{\link[YAPSA]{attribute_sequence_contex_indel}},
\code{\link[YAPSA]{attribute_sequence_contex_indel}} and then
\code{\link[YAPSA]{attribution_of_indels}}. The runtime of the function is
about 1 sec per 6 variants as sequence context as well as INDEL
calssification are timeconsuming to compute (optimization ongoing)
}
\examples{
data(sigs_pcawg)
data(GenomeOfNl_raw)
temp_df <- translate_to_hg19(GenomeOfNl_raw[1:200,],"CHROM")
temp_df$PID <- sample(c("PID1","PID2","PID3","PID4","PID5"),200,replace=TRUE)
temp <- create_indel_mutation_catalogue_from_df(in_dat = temp_df,
   in_signature_df = PCAWG_SP_ID_sigs_df,
   in_REF.field = "REF",
   in_ALT.field = "ALT",
   in_verbose = FALSE)
dim(temp)
head(temp)

}
