% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basic_functions.R
\name{compare_exposures}
\alias{compare_exposures}
\title{Compares alternative exposures}
\usage{
compare_exposures(in_exposures1_df, in_exposures2_df, deselect_flag = TRUE)
}
\arguments{
\item{in_exposures1_df}{Numeric data frame with exposures, ideally the
smaller exposure data is supplied first.}

\item{in_exposures2_df}{Numeric data frame with exposures, ideally the bigger
exposure data is supplied second.}

\item{deselect_flag}{Wehther signatures absent in both exposure data frames
should be removed.}
}
\value{
A list with entries \code{merge_df}, \code{all_cor.coeff},
  \code{all_p.value}, \code{cor.coeff_vector}, \code{p.value_vector},
  \code{all_cor.test}, and \code{cor.test_list}. \itemize{ \item
  \code{merge_df}: Merged molten input exposure data frames \item
  \code{all_cor.coeff}: Pearson correlation coefficient for all data points,
  i.e. taken all signatures together \item \code{all_p.value}: P-value of the
  Pearson test for all data points, i.e. taken all signatures together \item
  \code{cor.coeff_vector}: A vector of Pearson correlation coefficients
  evaluated for every signature independently \item \code{p.value_vector}: A
  vector of p-values of the Pearson tests evaluated for every signature
  independently \item \code{all_cor.test}: A data structure as returned by
  \code{\link{cor.test}} for all data points, i.e. taken all signatures
  together \item \code{cor.test_list}: A list of data structures as returned
  by \code{\link{cor.test}}, but evaluated for every signature independently
  }
}
\description{
Compares exposures computed by two alternative approaches for the same cohort
}
\examples{
 NULL

}
