% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{dosePlot}
\alias{dosePlot}
\title{plot dose data}
\usage{
dosePlot(
  object,
  model.id,
  max.time = NULL,
  treatment.only = FALSE,
  vol.normal = FALSE,
  concurrent.time = FALSE,
  point.shape = 21,
  point.size = 3,
  line.size = 4,
  point.color = "#878787",
  line.color = "#bababa",
  fill.col = c("#f5f5f5", "#E55100"),
  modify.x.axis = FALSE
)
}
\arguments{
\item{object}{Xeva object.}

\item{model.id}{one or multiple model.id}

\item{max.time}{Maximum time point of the plot. Default \code{NULL} will plot complete data}

\item{treatment.only}{Default \code{FALSE}. Given full data \code{treatment.only=TRUE} will plot data only during treatment}

\item{vol.normal}{Default \code{FALSE}. If \code{TRUE}, volume will be normalized}

\item{concurrent.time}{Default \code{FALSE}. If \code{TRUE}, cut the batch data such that control and treatment will end at the same time point}

\item{point.shape}{shape of the point}

\item{point.size}{size of the point}

\item{line.size}{size of the line}

\item{point.color}{color for point}

\item{line.color}{color for line}

\item{fill.col}{a vector with color to fill}

\item{modify.x.axis}{Default \code{FALSE}}
}
\value{
A ggplot2 plot
}
\description{
plot data for dose in model.id
}
\examples{
data(brca)
dosePlot(brca, model.id=c("X.6047.LJ16","X.6047.LJ16.trab"), fill.col=c("#f5f5f5", "#993404"))
}
