#' PDXE breast cancer dataset
#'
#' A Xeva object containing only breast cancer PDXs from the PDXE dataset
#' For details about PDX-MI, see:
#' Gao et al. High-throughput screening using patient-derived tumor xenografts to predict clinical trial drug response. Nature medicine, 21(11):1318, 2015.
#' @source \url{https://www.nature.com/articles/nm.3954?draft=journal}
#'
#' @usage data(brca)
"brca"

#' Example PDX dataset
#'
#' A Xeva object containing anonymous PDX data with replicates. Each batch has 5 replicates.
#'
#' @usage data(repdx)
"repdx"

#' PDX-MI data
#'
#' A dataset containing PDX models minimal information (PDX-MI) standard and corresponding Xeva variable.
#'
#' For details about PDX-MI, see:
#'
#' Meehan, Terrence F., et al. "PDX-MI: minimal information for patient-derived tumor xenograft models." Cancer research 77.21 (2017): e62-e66.
#'
#' @source \url{http://cancerres.aacrjournals.org/lookup/doi/10.1158/0008-5472.CAN-17-0582}
#' @usage data(PDXMI)
"PDXMI"


