% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network_plots.R
\name{xina_plot_single}
\alias{xina_plot_single}
\title{xina_plot_single}
\usage{
xina_plot_single(xina_result, protein_list, centrality_type = NULL,
  layout_specified = "", vertex_label_flag = TRUE, main = NULL,
  vertex.label.color = "black", vertex.color = NA,
  edge.color = "darkgray", vertex.label.dist = 0.6,
  vertex.label.cex = 0.8, edge.arrow.size = 0.4, vertex.size = 10,
  vertex.shape = "sphere", legend_location = "bottom",
  num_breaks = 5, digits_round_up = 5, flag_simplify = TRUE,
  flag_legend = TRUE)
}
\arguments{
\item{xina_result}{A list containing XINA network analysis results. See \link[XINA]{xina_analysis}}

\item{protein_list}{A vector of gene names to draw a protein-protein interaction network graph.}

\item{centrality_type}{'centrality_type' should be one of
c('Degree', 'Eigenvector', 'Hub', 'Authority', 'Closeness', 'Betweenness')
     \tabular{rl}{
      \strong{Centrality score} \tab \strong{igraph function}\cr
      Degree \tab \link[igraph]{degree}\cr
      Eigenvector \tab \link[igraph]{eigen_centrality}\cr
      Hub \tab \link[igraph]{hub_score}\cr
      Authority \tab \link[igraph]{authority_score}\cr
      Closeness \tab \link[igraph]{closeness}\cr
      Betweenness \tab \link[igraph]{betweenness}\cr
     }}

\item{layout_specified}{This can change network layout.
'layout_specified' should be one of c('sphere', 'star', 'gem', 'tree', 'circle', 'random', 'nicely').
XINA's layouts are based on igraph's layout. See \link[igraph]{layout_}
     \tabular{rl}{
      \strong{Layout} \tab \strong{igraph layout name}\cr
      sphere \tab \link[igraph]{layout_on_sphere}\cr
      star \tab \link[igraph]{layout_as_star}\cr
      gem \tab \link[igraph]{layout_with_gem}\cr
      tree \tab \link[igraph]{layout_as_tree}\cr
      circle \tab \link[igraph]{layout_in_circle}\cr
      random \tab \link[igraph]{layout_randomly}\cr
      nicely \tab \link[igraph]{layout_nicely}\cr
     }
Default is 'layout_nicely' of igraph}

\item{vertex_label_flag}{If vertex_label_flag is TRUE (default), igraph network graphs will be labeled by gene names
If vertex_label_flag is FALSE, igraph network graphs will be drawn without labels}

\item{main}{Title of network figure.  IF it is NULL (default), it will be the number of plotted proteins}

\item{vertex.label.color}{Color of labels. Default is black}

\item{vertex.color}{Color of nodes. Default is pink.}

\item{edge.color}{Color of edges. Default is pink.}

\item{vertex.label.dist}{Distance between node and label. Default is 0.6}

\item{vertex.label.cex}{Size of labels  Default is 0.8}

\item{edge.arrow.size}{Size of edges  Default is 0.4}

\item{vertex.size}{Size of nodes  Default is 10}

\item{vertex.shape}{You can choose node shape. Default is 'sphere'.  See \link[igraph]{shapes}}

\item{legend_location}{If centrality_type is chosen,
'xina_plot_single' adds the color legend guiding rank of nodes based on the centrality score.
Default is 'bottomright', but you can choose one of these 'bottomright', 'bottom', 'bottomleft',
'left', 'topleft', 'top', 'topright', 'right' and 'center'.}

\item{num_breaks}{'num_breaks' is the number of ranks based on network centrality. Default is 5.}

\item{digits_round_up}{See \link[base]{Round}}

\item{flag_simplify}{If it is TRUE (default), XINA will exclude unconnected proteins}

\item{flag_legend}{If it is TRUE, a legend will be printed out together.}
}
\value{
A PNG file (XINA_Cluster_Networks.png) displaying protein-protein interaction network plots
of all the clusters and a list containing XINA network analysis results
}
\description{
xina_plot_single draws protein-protein interaction network plot for given 'protein_list'.
}
\examples{
## the following code is to show how it works quickly
## load XINA example data
data(xina_example)

## load the previously processed XINA analysis results
# if you want to learn how to run 'xina_analysis', please see \\link[XINA]{xina_analysis}
data(xina_result_example)

# get gene names that are clustered to #21 in "Stimulus2" condition
subgroup <- subset(example_clusters$aligned, Stimulus2==21)
protein_list <- subgroup$`Gene name`

# Calculate protein-protein interaction network
xina_plot_single(xina_result_example, protein_list)

# Calculate protein-protein interaction network and Eigenvector centrality
eigen_info <- xina_plot_single(xina_result_example, protein_list, centrality_type='Eigenvector')

}
