% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network_plots.R
\name{xina_plot_all}
\alias{xina_plot_all}
\title{xina_plot_all}
\usage{
xina_plot_all(xina_result, clustering_result, condition = "all",
  centrality_type = NULL, flag_simplify = TRUE, num_breaks = 5,
  layout_specified = "", vertex_label_flag = FALSE,
  vertex.label.color = "black", vertex.color = "", edge.color = NULL,
  vertex.label.dist = 0.6, vertex.label.cex = 0.8,
  edge.arrow.size = 0.4, vertex.size = 10, vertex.shape = "sphere",
  legend_location = "bottom", num_clusters_in_row = 5,
  flag_unknown_only = FALSE, img_size = NULL, img_qual = 300)
}
\arguments{
\item{xina_result}{A list containing XINA network analysis results. See \link[XINA]{xina_analysis}}

\item{clustering_result}{A list containing XINA clustering results. See \link[XINA]{xina_clustering}}

\item{condition}{Default is 'all', which means use all the proteins to draw graphs.
If you specify the experimental condition name used for XINA clustering,
xina_plot_all will draw graphs using specific condition's proteins.}

\item{centrality_type}{'centrality_type' should be one of
c('Degree', 'Eigenvector', 'Hub', 'Authority', 'Closeness', 'Betweenness')
     \tabular{rl}{
      \strong{Centrality score} \tab \strong{igraph function}\cr
      Degree \tab \link[igraph]{degree}\cr
      Eigenvector \tab \link[igraph]{eigen_centrality}\cr
      Hub \tab \link[igraph]{hub_score}\cr
      Authority \tab \link[igraph]{authority_score}\cr
      Closeness \tab \link[igraph]{closeness}\cr
      Betweenness \tab \link[igraph]{betweenness}\cr
     }}

\item{flag_simplify}{If it is TRUE (default), XINA will exclude unconnected proteins}

\item{num_breaks}{'num_breaks' is the number of ranks based on network centrality. Default is 5.}

\item{layout_specified}{This can change network layout.
'layout_specified' should be one of c('sphere', 'star', 'gem', 'tree', 'circle', 'random', 'nicely').
XINA's layouts are based on igraph's layout. See \link[igraph]{layout_}
     \tabular{rl}{
      \strong{Layout} \tab \strong{igraph layout name}\cr
      sphere \tab \link[igraph]{layout_on_sphere}\cr
      star \tab \link[igraph]{layout_as_star}\cr
      gem \tab \link[igraph]{layout_with_gem}\cr
      tree \tab \link[igraph]{layout_as_tree}\cr
      circle \tab \link[igraph]{layout_in_circle}\cr
      random \tab \link[igraph]{layout_randomly}\cr
      nicely \tab \link[igraph]{layout_nicely}\cr
     }
Default is 'layout_nicely' of igraph}

\item{vertex_label_flag}{If vertex_label_flag is TRUE (default), igraph network graphs will be labeled by gene names
If vertex_label_flag is FALSE, igraph network graphs will be drawn without labels}

\item{vertex.label.color}{Color of labels. Default is black}

\item{vertex.color}{Color of nodes. Default is pink.}

\item{edge.color}{Color of edges. Default is pink.}

\item{vertex.label.dist}{Distance between node and label. Default is 0.6}

\item{vertex.label.cex}{Size of labels  Default is 0.8}

\item{edge.arrow.size}{Size of edges  Default is 0.4}

\item{vertex.size}{Size of nodes  Default is 10}

\item{vertex.shape}{You can choose node shape. Default is 'sphere'.  See \link[igraph]{shapes}}

\item{legend_location}{If centrality_type is chosen,
xina_plot_single add the color legend guiding rank of nodes based on the centrality score.
Default is 'bottomright', but you can choose one of these 'bottomright', 'bottom', 'bottomleft',
'left', 'topleft', 'top', 'topright', 'right' and 'center'.}

\item{num_clusters_in_row}{The number of clusters in a row on the XINA network plot. Default is 5.}

\item{flag_unknown_only}{If this is TRUE, 'xina_plot_all' will plot proteins that do not have any protein-protein interaction in the given database}

\item{img_size}{Set the image size. For width=1000 and height=1500,
it is img_size=c(1000,1500). Default is c(3000,3000)}

\item{img_qual}{Set the image resolution. Default is 300.}
}
\value{
PNG images of PPI network plots of all the clusters
}
\description{
xina_plot_all is to draw protein-protein interaction network plots of all the clusters
}
\examples{
## the following code is to show how it works quickly
## load XINA example data
data(xina_example)

## load the previously processed XINA analysis results
# if you want to learn how to run 'xina_analysis', please see \\link[XINA]{xina_analysis}
data(xina_result_example)

# XINA network plots
xina_plot_all(xina_result_example, example_clusters)

# XINA network plots for Control condition
xina_plot_all(xina_result_example, example_clusters, condition='Control')

}
