% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering_plots.R
\name{plot_clusters_all}
\alias{plot_clusters_all}
\title{plot_clusters_all}
\usage{
plot_clusters_all(clustering_result, selected_condition = NULL)
}
\arguments{
\item{clustering_result}{A list containing XINA clustering results.
See \link[XINA]{xina_clustering}}

\item{selected_condition}{A condition name to draw the kinetics plot}
}
\value{
a list containing clustering results and pdf file
containing a BIC plot in current working directory.
}
\description{
Draw line graphs of all the proteins in the given dataset
}
\examples{

# load XINA example data
data(xina_example)

# Plot kinetics of all the proteins in Control
plot_clusters_all(example_clusters, selected_condition="Control")

# Plot kinetics of all the proteins in Stimulus1
plot_clusters_all(example_clusters, selected_condition="Stimulus1")

# Plot kinetics of all the proteins in Stimulus2
plot_clusters_all(example_clusters, selected_condition="Stimulus2")

# Plot kinetics of all the proteins in three data
plot_clusters_all(example_clusters)

}
