% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coregulstions.R
\name{get_condition_biased_comigrations}
\alias{get_condition_biased_comigrations}
\title{get_condition_biased_comigrations}
\usage{
get_condition_biased_comigrations(clustering_result, count_table = NULL,
  selected_conditions, condition_composition, threshold_percent = 50,
  color_for_null = "gray", color_for_highly_matched = "red4",
  cex = 0.7, alpha = 0.3)
}
\arguments{
\item{clustering_result}{A list containing XINA clustering results.
See \link[XINA]{xina_clustering}}

\item{count_table}{A data frame generated by using \link[plyr]{count}.
If count_table is NULL (by default), XINA will consider all the comigrations.}

\item{selected_conditions}{A vector of condition names used in XINA clustering results.
The number of selected conditions should be at least two.}

\item{condition_composition}{The resulting data frame of 'plot_condition_compositions'.
See \link[XINA]{plot_condition_compositions}.}

\item{threshold_percent}{Default is 50.  The percentage threshold for finding condition-biased clusters}

\item{color_for_null}{A color for non-condition-biased comigrations. Default is 'gray'}

\item{color_for_highly_matched}{A color for comigrations that are involved with more than two condition-biased clusters. Default is 'red4'}

\item{cex}{Size of cluster number on block axis. Default if 0.7. See \link[alluvial]{alluvial}.}

\item{alpha}{Transparency of alluvia colors. Default is 0.3. See \link[alluvial]{alluvial}.}
}
\value{
An alluvial plot displaying comigrations and the data frame containing condition-biased comigrations.
}
\description{
get comigrations that at least one biased cluster is involved in.
Biased clusters are defined by
}
\examples{

# load XINA example data
data(xina_example)

# get a vector of experimental conditions analyzed in the clustering results
conditions <- as.vector(example_clusters$condition)

# get condition composition information
condition_composition <- plot_condition_compositions(example_clusters)

comigrations_size10 <- alluvial_enriched(example_clusters, conditions, comigration_size=10)
# Finding condition-biased comigrations by 50\% threshold
condition_biased_comigrations <-
get_condition_biased_comigrations(clustering_result=example_clusters,
count_table=comigrations_size10, selected_conditions=conditions,
condition_composition=condition_composition)

# Finding condition-biased comigrations by 70\% threshold
condition_biased_comigrations <-
get_condition_biased_comigrations(clustering_result=example_clusters,
count_table=comigrations_size10, selected_conditions=conditions,
condition_composition=condition_composition,
threshold_percent=70)

}
