% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotSpatialReducedDim.R
\name{spatialReducedDim}
\alias{spatialReducedDim}
\title{Plot dimension reduction components in space}
\usage{
spatialReducedDim(
  sfe,
  dimred,
  ncomponents = NULL,
  components = ncomponents,
  colGeometryName = 1L,
  sample_id = "all",
  ncol = NULL,
  ncol_sample = NULL,
  annotGeometryName = NULL,
  rowGeometryName = NULL,
  rowGeometryFeatures = NULL,
  annot_aes = list(),
  annot_fixed = list(),
  tx_fixed = list(),
  exprs_values = "logcounts",
  bbox = NULL,
  tx_file = NULL,
  image_id = NULL,
  channel = NULL,
  maxcell = 5e+05,
  aes_use = c("fill", "color", "shape", "linetype"),
  divergent = FALSE,
  diverge_center = NULL,
  annot_divergent = FALSE,
  annot_diverge_center = NULL,
  size = 0,
  shape = 16,
  linewidth = 0,
  linetype = 1,
  alpha = 1,
  color = NA,
  fill = "gray80",
  scattermore = FALSE,
  pointsize = 0,
  bins = NULL,
  summary_fun = sum,
  hex = FALSE,
  show_axes = FALSE,
  dark = FALSE,
  palette = colorRampPalette(c("black", "white"))(255),
  normalize_channels = FALSE,
  ...
)
}
\arguments{
\item{sfe}{A \code{SpatialFeatureExperiment} object.}

\item{dimred}{A string or integer scalar indicating the reduced dimension
result in \code{reducedDims(sfe)} to plot.}

\item{ncomponents}{A numeric scalar indicating the number of dimensions to
plot, starting from the first dimension. Alternatively, a numeric vector
specifying the dimensions to be plotted.}

\item{components}{A numeric scalar or vector specifying which dimensions to
be plotted. Use this instead of \code{ncomponents} when plotting only one
dimension.}

\item{colGeometryName}{Name of a \code{colGeometry} \code{sf} data frame
whose numeric columns of interest are to be used to compute the metric. Use
\code{\link{colGeometryNames}} to look up names of the \code{sf} data
frames associated with cells/spots.}

\item{sample_id}{Sample(s) in the SFE object whose cells/spots to use. Can be
"all" to compute metric for all samples; the metric is computed separately
for each sample.}

\item{ncol}{Number of columns if plotting multiple features. Defaults to
\code{NULL}, which means using the same logic as \code{facet_wrap}, which
is used by \code{patchwork}'s \code{\link{wrap_plots}} by default.}

\item{ncol_sample}{If plotting multiple samples as facets, how many columns
of such facets. This is distinct from \code{ncols}, which is for multiple
features. When plotting multiple features for multiple samples, then the
result is a multi-panel plot each panel of which is a plot for each feature
facetted by samples.}

\item{annotGeometryName}{Name of a \code{annotGeometry} of the SFE object, to
annotate the gene expression plot.}

\item{rowGeometryName}{Name of a \code{rowGeometry} of the SFE object to
plot.}

\item{rowGeometryFeatures}{Which features from \code{rowGeometry} to plot.
Can only be a small number to avoid overplotting. Different features are
distinguished by point shape. By default (\code{NULL}), when
\code{rowGeometryName} is specified, this will be whichever items in
\code{features} that are also in the row names of the SFE object. If
features specified for this argument are not the same as or a subset of
those in argument \code{features}, then the spots of all features specified
here will be plotted, differentiated by point shape.}

\item{annot_aes}{A named list of plotting parameters for the annotation sf
data frame. The names are which geom (as in ggplot2, such as color and
fill), and the values are column names in the annotation sf data frame.
Tidyeval is NOT supported.}

\item{annot_fixed}{Similar to \code{annot_aes}, but for fixed aesthetic
settings, such as \code{color = "gray"}. The defaults are the same as the
relevant defaults for this function.}

\item{tx_fixed}{Similar to \code{annot_fixed}, but to specify fixed aesthetic
for transcript spots.}

\item{exprs_values}{Integer scalar or string indicating which assay of x
contains the expression values.}

\item{bbox}{A bounding box to specify a smaller region to plot, useful when
the dataset is large. Can be a named numeric vector with names "xmin",
"xmax", "ymin", and "ymax", in any order. If plotting multiple samples, it
should be a matrix with sample IDs as column names and "xmin", "ymin",
"xmax", and "ymax" as row names. If multiple samples are plotted but
\code{bbox} is a vector rather than a matrix, then the same bounding box
will be used for all samples. You may see points at the edge of the
geometries if the intersection between the bounding box and a geometry
happens to be a point there. If \code{NULL}, then the entire tissue is
plotted.}

\item{tx_file}{File path to GeoParquet file of the transcript spots if you
don't wish to load all transcript spots into the SFE object. See
\code{\link{formatTxSpots}} on generating such a GeoParquet file.}

\item{image_id}{ID of the image to plot behind the geometries. If
\code{NULL}, then not plotting images. Use \code{\link{imgData}} to see
image IDs present. To plot multiple grayscale images as different RGB
channels, use a named vector here, whose names are channel names (r, g, b),
and values are image_ids of the corresponding images. The RGB colorization
may not be colorblind friendly. When plotting multiple samples, it is
assumed that the same image_id is used for each channel across different
samples.}

\item{channel}{Numeric vector indicating which channels in a multi-channel
image to plot. If \code{NULL}, grayscale is plotted if there is 1 channel
and RGB for the first 3 channels. The numeric vector can be named (r, g, b)
to indicate which channel maps to which color. The RGB colorization may not
be colorblind friendly. This argument cannot be specified while
\code{image_id} is a named vector to plot different grayscale images as
different channels.}

\item{maxcell}{Maximum number of pixels to plot in the image. If the image is
larger, it will be resampled so it have less than this number of pixels to
save memory and for faster plotting. We recommend reducing this number when
plotting multiple facets.}

\item{aes_use}{Aesthetic to use for discrete variables. For continuous
variables, it's always "fill" for polygons and point shapes 21-25. For
discrete variables, it can be fill, color, shape, or linetype, whenever
applicable. The specified value will be changed to the applicable
equivalent. For example, if the geometry is point but "linetype" is
specified, then "shaped" will be used instead.}

\item{divergent}{Logical, whether a divergent palette should be used.}

\item{diverge_center}{If \code{divergent = TRUE}, the center from which the
palette should diverge. If \code{NULL}, then not centering.}

\item{annot_divergent}{Just as \code{divergent}, but for the annotGeometry in
case it's different.}

\item{annot_diverge_center}{Just as \code{diverge_center}, but for the
annotGeometry in case it's different.}

\item{size}{Fixed size of points. For points defaults to 0.5. Ignored if
\code{size_by} is specified.}

\item{shape}{Fixed shape of points, ignored if \code{shape_by} is specified
and applicable.}

\item{linewidth}{Width of lines, including outlines of polygons. For
polygons, this defaults to 0, meaning no outlines.}

\item{linetype}{Fixed line type, ignored if \code{linetype_by} is specified
and applicable.}

\item{alpha}{Transparency.}

\item{color}{Fixed color for \code{colGeometry} if \code{color_by} is not
specified or not applicable, or for \code{annotGeometry} if
\code{annot_color_by} is not specified or not applicable.}

\item{fill}{Similar to \code{color}, but for fill.}

\item{scattermore}{Logical, whether to use the \code{scattermore} package to
greatly speed up plotting numerous points. Only used for POINT
\code{colGeometries}. If the geometry is not POINT, then the centroids are
used. Recommended for plotting hundreds of thousands or more cells where
the cell polygons can't be seen when plotted due to the large number of
cells and small plot size such as when plotting multiple panels for
multiple features.}

\item{pointsize}{Radius of rasterized point in \code{scattermore}. Default to
0 for single pixels (fastest).}

\item{bins}{If binning the \code{colGeometry} in space due to large number of
cells or spots, the number of bins, passed to \code{\link{geom_bin2d}} or
\code{\link{geom_hex}}. If \code{NULL} (default), then the
\code{colGeometry} is plotted without binning. If binning, a point geometry
is recommended. If the geometry is not point, then the centroids will be
used.}

\item{summary_fun}{Function to summarize the feature value when the
\code{colGeometry} is binned.}

\item{hex}{Logical, whether to use \code{\link{geom_hex}}. Note that
\code{geom_hex} is broken in \code{ggplot2} version 3.4.0. Please update
\code{ggplot2} if you are getting horizontal stripes when \code{hex =
TRUE}.}

\item{show_axes}{Logical, whether to show axes.}

\item{dark}{Logical, whether to use dark theme. When using dark theme, the
palette will have lighter color represent higher values as if glowing in
the dark. This is intended for plotting gene expression on top of
fluorescent images.}

\item{palette}{Vector of colors to use to color grayscale images.}

\item{normalize_channels}{Logical, whether to normalize each channel of the
image individually. Should be \code{FALSE} for bright field color images
such as H&E but should set to \code{TRUE} for fluorescent images.}

\item{...}{Other arguments passed to \code{\link{wrap_plots}}.}
}
\value{
Same as in \code{\link{plotSpatialFeature}}. A \code{ggplot2} object
  if plotting one component. A \code{patchwork} object if plotting multiple
  components.
}
\description{
Such as plotting the value of projection of gene expression of each cell to a
principal component in space. At present, this function does not work for the
3D array of geographically weighted PCA (GWPCA), but a future version will
deal with GWPCA results.
}
\examples{
library(SFEData)
library(scater)
sfe <- McKellarMuscleData("small")
sfe <- logNormCounts(sfe)
sfe <- runPCA(sfe, ncomponents = 2)
spatialReducedDim(sfe, "PCA", ncomponents = 2, "spotPoly",
    annotGeometryName = "tissueBoundary",
    divergent = TRUE, diverge_center = 0
)
# Basically PC1 separates spots not on tissue from those on tissue.
}
\seealso{
scater::plotReducedDim
}
\concept{Spatial plotting}
