% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Uniprot2GO.R
\name{Uniprot2GO}
\alias{Uniprot2GO}
\title{Check available organisms databases at Uniprot.}
\usage{
Uniprot2GO()
}
\value{
a  \code{\link{genomic_ressource-class}} object required by \code{\link{annotate}}.
}
\description{
Check the \href{http://www.ebi.ac.uk/GOA}{Uniprot-GOA} available organisms.
}
\details{
This function downloads the current_release_numbers file (ftp://ftp.ebi.ac.uk/pub/databases/GO/goa/current_release_numbers.txt) from
\href{http://www.ebi.ac.uk/GOA}{Uniprot-GOA} which contains available organisms.
}
\examples{
\dontrun{
# List Uniprot-GOA available organisms
Uniprot<-ViSEAGO::Uniprot2GO()
}
}
\references{
Matt Dowle and Arun Srinivasan (2017). data.table: Extension of `data.frame`. R package version 1.10.4. https://CRAN.R-project.org/package=data.table.

Huntley, RP, Sawford, T, Mutowo-Meullenet, P, Shypitsyna, A, Bonilla, C, Martin, MJ, O'Donovan, C (2015).
The GOA database: gene Ontology annotation updates for 2015. Nucleic Acids Res., 43, Database issue:D1057-63.
}
\seealso{
Other genomic_ressource: 
\code{\link{Bioconductor2GO}()},
\code{\link{Custom2GO}()},
\code{\link{Ensembl2GO}()},
\code{\link{EntrezGene2GO}()},
\code{\link{annotate}()},
\code{\link{available_organisms}()},
\code{\link{genomic_ressource-class}},
\code{\link{taxonomy}()}
}
\concept{genomic_ressource}
