% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/venn-pie.R
\name{vennpie,Venn-method}
\alias{vennpie,Venn-method}
\title{Create a Venn-pie visualization}
\usage{
\S4method{vennpie}{Venn}(
  object,
  subset = NULL,
  top = 31,
  min = 0,
  color = NULL,
  revcolor = "lightgrey",
  any = NULL,
  show.number = TRUE,
  show.x = TRUE,
  sep = "_",
  log = FALSE,
  base = NULL,
  percentage = FALSE
)
}
\arguments{
\item{object}{A Venn object}

\item{subset}{Character vector of subset names to highlight}

\item{top}{Maximum number of subsets to display. Default: 31}

\item{min}{Minimum number of sets an element must be in. Default: 0}

\item{color}{Optional vector of colors for the subsets}

\item{revcolor}{Color for non-highlighted subsets. Default: "lightgrey"}

\item{any}{Highlight subsets shared by exactly this many sets}

\item{show.number}{Logical: show counts in labels? Default: TRUE}

\item{show.x}{Logical: show subset labels? Default: TRUE}

\item{sep}{Character separator for subset names}

\item{log}{Logical: use log scale for counts? Default: FALSE}

\item{base}{Base for log transformation if log=TRUE}

\item{percentage}{Logical: show percentages instead of counts? Default: FALSE}

\item{title}{Optional plot title}

\item{interactive}{Logical: create interactive plot? Default: FALSE}

\item{...}{Additional arguments}
}
\value{
A ggplot2 or plotly object
}
\description{
Creates a pie-chart-like visualization of set intersections,
  which is particularly useful for visualizing more than 5 sets
}
\author{
Kai Guo
}
