% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/venndetail.R
\name{make_subset}
\alias{make_subset}
\title{Create subsets from a list of sets}
\usage{
make_subset(x, sep = "_")
}
\arguments{
\item{x}{A list of vectors}

\item{sep}{Character used to separate set names in subset labels}
}
\value{
A named list where each element contains the unique items in that subset
}
\description{
Identifies all possible intersections between sets and returns
  a list of subsets
}
\examples{
A <- sample(1:100, 40, replace = FALSE)
B <- sample(1:100, 60, replace = FALSE)
C <- sample(1:100, 40, replace = FALSE)
x <- list(A = A, B = B, C = C)
subsets <- make_subset(x)
lengths(subsets)  # Number of elements in each subset
}
\author{
Kai Guo
}
