% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/misc.R
\name{detail}
\alias{detail}
\alias{detail,Venn-method}
\title{Get subset details from a Venn object}
\usage{
detail(object)

\S4method{detail}{Venn}(object)
}
\arguments{
\item{object}{A Venn object}
}
\value{
A named numeric vector with counts for each subset
}
\description{
Returns a named numeric vector with counts for each subset

The objective of this function is to summarizes the overlaps
across groups identified by venndetail without creating diagram.
}
\examples{
A <- sample(1:100, 40, replace = FALSE)
B <- sample(1:100, 60, replace = FALSE)
C <- sample(1:100, 40, replace = FALSE)
res <- venndetail(list(A = A, B = B, C = C))
detail(res)
A <- sample(1:100, 40, replace = FALSE)
B <- sample(1:100, 60, replace = FALSE)
C <- sample(1:100, 40, replace = FALSE)
res <- venndetail(list(A = A, B = B, C = C))
detail(res)
}
\author{
Kai Guo
}
