% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{compareVenn}
\alias{compareVenn}
\title{Compare two Venn objects}
\usage{
compareVenn(x, y, what = c("groups", "subsets", "all"))
}
\arguments{
\item{x}{First Venn object}

\item{y}{Second Venn object}

\item{what}{What to compare: "groups" (default), "subsets", or "all"}
}
\value{
A list with differences between the objects
}
\description{
Compares two Venn objects and returns a list of differences
}
\examples{
# Create two Venn objects
A1 <- sample(1:100, 40, replace = FALSE)
B1 <- sample(1:100, 60, replace = FALSE)
res1 <- venndetail(list(A = A1, B = B1))

A2 <- sample(1:100, 45, replace = FALSE)
B2 <- sample(1:100, 55, replace = FALSE)
res2 <- venndetail(list(A = A2, B = B2))

# Compare the objects
compareVenn(res1, res2)
}
\author{
Kai Guo
}
