% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/methods-HmmGRanges.R,
%   R/methods-HmmTrellisParam.R
\name{xyplotList}
\alias{xyplotList}
\alias{xyplotList,HmmGRanges,SnpArrayExperiment-method}
\alias{xyplotList,GRangesList,SnpArrayExperiment-method}
\alias{xygrid}
\title{Lattice-style plots for granges and SnpArrayExperiment objects}
\usage{
xyplotList(granges, se, param = HmmTrellisParam())

\S4method{xyplotList}{HmmGRanges,SnpArrayExperiment}(granges, se, param = HmmTrellisParam())

\S4method{xyplotList}{GRangesList,SnpArrayExperiment}(granges, se, param = HmmTrellisParam())

xygrid(trellis_plot, viewports, granges)
}
\arguments{
\item{granges}{a \code{HmmGRanges} object}

\item{se}{a \code{SnpArrayExperiment}}

\item{param}{trellis parameters for plotting HMM}

\item{trellis_plot}{an object of class \code{trellis}}

\item{viewports}{a list of viewports as provided by the \code{viewports} function}
}
\description{
Data for the graphic is generated by a call to \code{grangesData}.
}
\examples{
if(require("BSgenome.Hsapiens.UCSC.hg18")){
  bsgenome <- BSgenome.Hsapiens.UCSC.hg18
  snp_exp <- getExampleSnpExperiment(bsgenome)
  seqlevels(snp_exp, pruning.mode="coarse") <- "chr22"
  fit <- hmm2(snp_exp)
  g <- reduce(hemizygous(fit), min.gapwidth=500e3)
  trellis_param <- HmmTrellisParam()
  fig <- xyplotList(g, snp_exp, trellis_param)
  vps <- viewports()
  xygrid(fig[[1]], vps, g)
}
}
\seealso{
\code{\link{viewports}}
}
