% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vcfCheck.R
\name{vcfCheck}
\alias{vcfCheck}
\title{Check quality parameters (optional), change IDs and encode genotypes numerically}
\usage{
vcfCheck(largeCollapsedVcf, father, mother, proband, check_quality = FALSE)
}
\arguments{
\item{largeCollapsedVcf}{The file in largeCollapsedVcf format.}

\item{father}{Name of the father's sample.}

\item{mother}{Name of the mother's sample.}

\item{proband}{Name of the proband's sample.}

\item{check_quality}{Optional argument. TRUE/FALSE. If quality parameters
want to be measured.
Default = FALSE}
}
\value{
largeCollapsedVcf (VariantAnnotation VCF format) object identical to the
input with samples renamed to standard names for the trio and a new metadata column
\emph{geno_coded} containing the numeric encoding of the trio genotypes for each variant.
}
\description{
This function takes a VCF file and converts it into a largeCollapsedVcf
object using the VariantAnnotation package. It also rename the sample for
subsequent steps needed in UPDhmm package and generates a numeric
encoding of the trio genotypes for each variant, which is stored in the metadata
column \emph{geno_coded}.
Additionally, it features an optional parameter, quality_check, which triggers warnings
when variants lack sufficient quality based on RD and GQ parameters in the input VCF.
}
\examples{
fl <- system.file("extdata", "test_het_mat.vcf.gz", package = "UPDhmm")
vcf <- VariantAnnotation::readVcf(fl)
processedVcf <-
   vcfCheck(vcf, proband = "NA19675", mother = "NA19678", father = "NA19679")

}
