% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateEvents.R
\name{computeTrioTotals}
\alias{computeTrioTotals}
\title{Compute per-sample total mean read depth for a trio}
\usage{
computeTrioTotals(
  vcf,
  expected_samples = c("father", "mother", "proband"),
  field_DP = NULL
)
}
\arguments{
\item{vcf}{A CollapsedVCF object containing the trio genotype data.}

\item{expected_samples}{Character vector of length 3 specifying the column
order of the trio: proband, mother, father. Default = c("proband","mother","father").}

\item{field_DP}{Optional character string specifying the FORMAT field in the VCF
to use for depth calculations.}
}
\value{
Numeric vector of per-sample mean read depths, named according to
expected_samples. Returns NULL if no valid depth field is found.
}
\description{
This internal helper function calculates the per-sample total mean read depth
across a VCF for a trio, optionally using a specified FORMAT field.
The resulting totals are used to normalize per-block depth ratios in
downstream analyses.
}
\details{
The function selects the depth or coverage field to use, giving priority to field_DP if specified and present in the VCF, followed by \code{DP} (standard depth) and then \code{AD} (allelic depth) if available.
If AD is used, the depth for each variant is calculated as the sum across all alleles per sample.
NA values are ignored when computing the per-sample mean depth.
}
\keyword{internal}
