% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collapseEvents.R
\name{collapseEvents}
\alias{collapseEvents}
\title{Collapse events per sample and chromosome}
\usage{
collapseEvents(subset_df, min_ME = 2, min_size = 5e+05)
}
\arguments{
\item{subset_df}{A data.frame containing event-level data with columns:
\itemize{
\item ID – Sample identifier.
\item chromosome – Chromosome name.
\item start – Start position of the event.
\item end – End position of the event.
\item group – Event group/class.
\item n_snps – Number of SNPs in the event.
\item n_mendelian_error – Number of Mendelian errors in the event.
\item ratio_proband, ratio_mother, ratio_father – depth-ratio metrics.
}}

\item{min_ME}{Minimum number of Mendelian errors required to retain an event
before collapsing (default: 2).}

\item{min_size}{Minimum genomic span size required to retain an event
before collapsing, in base pairs (default: 500e3).}
}
\value{
A data.frame with collapsed events and columns:
\itemize{
\item ID – Sample identifier.
\item chromosome – Chromosome name.
\item start, end – Genomic span of the collapsed block.
\item group – HMM state of the block.
\item n_events – Number of events collapsed.
\item total_mendelian_error – Sum of Mendelian errors across events.
\item total_size – Total genomic span size covered by events.
\item total_snps – Total SNPs in the overlapping events.
\item prop_covered – Proportion of the region covered by events.
\item ratio_proband, ratio_mother, ratio_father – Weighted mean ratios across the collapsed events.
If all values are NA, the column will contain NA_real_.
\item collapsed_events – Comma-separated list of collapsed events.
}
}
\description{
This function collapses genomic events per individual, chromosome, and group,
summarising the number of events, total Mendelian errors, the total span size,
and a string listing all merged event coordinates.
}
\details{
When values are available in the ratio columns (\code{ratio_proband}, \code{ratio_mother}, \code{ratio_father}),
weighted mean ratios are computed across the collapsed events.
The weighted mean ratio is calculated as:

\deqn{\frac{\sum_{i} r_i \times N_i}{\sum_{i} N_i}}

where \eqn{r_i} is the ratio of each individual event and \eqn{N_i} the number
of SNPs in that event.
If all values in a ratio column are \code{NA}, the corresponding collapsed value will be \code{NA_real_}.
}
\examples{
all_events <- data.frame(
ID = c("S1", "S1", "S1", "S2", "S2"),
chromosome = c("1", "1", "1", "2", "2"),
start = c(100e4, 200e4, 300e4, 500e4, 600e4),
end   = c(160e4, 260e4, 360e4, 560e4, 700e4),
group = c("iso_mat", "iso_mat", "het_pat", "iso_mat", "iso_mat"),
n_mendelian_error = c(5, 10, 2, 50, 30),
stringsAsFactors = FALSE
)
out <- collapseEvents(all_events)

}
