% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateEvents.R
\name{calculateEvents}
\alias{calculateEvents}
\title{Calculate UPD events in trio VCFs.}
\usage{
calculateEvents(
  largeCollapsedVcf,
  hmm = NULL,
  field_DP = NULL,
  add_ratios = FALSE,
  BPPARAM = BiocParallel::SerialParam(),
  verbose = FALSE
)
}
\arguments{
\item{largeCollapsedVcf}{The VCF file in the general format
(largeCollapsedVcf) with VariantAnnotation package. Previously edited with
\code{vcfCheck()} function from UPDhmm package.}

\item{hmm}{Default = \code{NULL}. If no arguments are added, the package
will use the default HMM already implemented, based on Mendelian
inheritance.}

\item{field_DP}{Default = \code{NULL}. Character string specifying which FORMAT field in the VCF
contains the read depth information to use in \code{addRatioDepth()}.
If \code{NULL} (default), the function will automatically try \code{"DP"} (standard depth)
or \code{"AD"} (allelic depths, summed across alleles).
Use this parameter if your VCF uses a non-standard field name for depth,
e.g. \code{field = "NR"} or \code{"field_DP"}.}

\item{add_ratios}{Logical; default = FALSE.

If TRUE, per-sample mean depth is computed across the entire VCF and
used to calculate normalized per-block depth ratios.}

\item{BPPARAM}{Parallelization settings, passed to
\link[BiocParallel]{bplapply}.
By default \code{BiocParallel::SerialParam()} (serial execution).
To enable parallelization, provide a BiocParallel backend, e.g.
\code{BiocParallel::MulticoreParam(workers = min(2, parallel::detectCores()))}
or \code{BiocParallel::SnowParam(workers = 2)}.
Note: when running under R CMD check or Bioconductor build systems,
the number of workers may be automatically limited (usually less or equal to 2).}

\item{verbose}{Logical, default = \code{FALSE}.
If \code{TRUE}, progress messages will be printed during processing.}
}
\value{
A \code{data.frame} object containing all detected events in the provided trio.
Columns include:
\itemize{
\item chromosome – chromosome name
\item start, end – genomic coordinates
\item group – inferred HMM state
\item n_snps – number of SNPs in the block
\item n_mendelian_error – number of Mendelian errors in the block
\item depth-ratio metrics (always present; if add_ratios = FALSE, filled with NA)
}

If no events are found, the function will return an empty \code{data.frame}.
}
\description{
This function predicts the hidden states by applying the Viterbi algorithm
using the Hidden Markov Model (HMM) from the UPDhmm package. It takes the
genotypes of the trio as input and includes a final step to simplify the
results into blocks.
}
\details{
\subsection{Custom HMM structure. The user can implement its own HMM.}{

A custom HMM must be a list following the structure of the HMM package, containing:

\itemize{
\item States – character vector of hidden state names
\item Symbols – vector of allowed observation symbols (genotype codes)
\item startProbs – named vector of initial state probabilities
\item transProbs – state transition probability matrix
\item emissionProbs – matrix of emission probabilities for each state × symbol
}
}
}
\examples{
file <- system.file(package = "UPDhmm", "extdata", "test_het_mat.vcf.gz")
vcf <- VariantAnnotation::readVcf(file)
processedVcf <- vcfCheck(vcf,
    proband = "NA19675", 
    mother = "NA19678",
    father = "NA19679"
)

# Run in serial mode (default)
res <- calculateEvents(processedVcf)

# Run in parallel with 2 cores
library(BiocParallel)
param <- MulticoreParam(workers = 2)
res_parallel <- calculateEvents(processedVcf, BPPARAM = param)
}
