% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contactsUMI4C.R
\name{splitUMI4C}
\alias{splitUMI4C}
\title{Split UMI4C reads}
\usage{
splitUMI4C(wk_dir, res_enz, cut_pos, numb_reads = 1e+09, min_flen = 20)
}
\arguments{
\item{wk_dir}{Working directory where to save the outputs generated by the
UMI-4c analysis.}

\item{res_enz}{Character containing the restriction enzyme sequence.}

\item{cut_pos}{Numeric indicating the nucleotide position where restriction
enzyme cuts (zero-based) (for example, for DpnII is 0).}

\item{numb_reads}{Number of lines from the FastQ file to load in each loop.
If having memory size problems, change it to a smaller number. Default=1e9.}

\item{min_flen}{Minimal fragment length to use for selecting the fragments.
Default=20}
}
\value{
Creates a compressed FASTQ file in \code{wk_dir/split} named
\code{basename(fastq)).fq.gz}, containing the
split reads based on the restriction enzyme used.
}
\description{
Split the prepared reads using the restrition enzyme information.
}
\examples{
if (interactive()) {
path <- downloadUMI4CexampleData(reduced = TRUE)

splitUMI4C(
    wk_dir = file.path(path, "CIITA"),
    res_enz = "GATC",
    cut_pos = 0
)
}
}
