% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TrajectoryGeometry.R
\name{plotPathProjectionCenterAndCircle}
\alias{plotPathProjectionCenterAndCircle}
\title{Plot a path, its projection, its center and its circle}
\usage{
plotPathProjectionCenterAndCircle(
  path,
  from = 1,
  to = nrow(path),
  projection,
  center,
  radius,
  color,
  circleColor = "white",
  pathPointSize = 8,
  projectionPointSize = 8,
  scale = 1.5,
  newFigure = TRUE
)
}
\arguments{
\item{path}{- A path of dimension 3 in the form of an N x 3 matrix.}

\item{from}{- The starting place of the section under
consideration.  This is used for marking the relevant
portion. It defaults to 1.}

\item{to}{- Likewise.  It defaults to nrow(path).}

\item{projection}{- The projection of the relevant portion of the
path.}

\item{center}{- The center of the projection points.}

\item{radius}{- The radius of the circle.}

\item{color}{- The color to use for this path and its associated
data.}

\item{circleColor}{- Sets the colour of the circle.
Defaults to white.}

\item{pathPointSize}{- Sets the size of points which represent the
path. Defaults to 8.}

\item{projectionPointSize}{- Sets the size of points which represent the
projected path. Defaults to 8.}

\item{scale}{- The path will be start (its actual start) at 0 and
will be scaled so that its most distant point will be at this
distance from the origin.  This is to keep it comparable in
size to the sphere. It defaults to 1.5.  Caution should be used
here when plotting multiple paths.}

\item{newFigure}{- When plotting a single figure or the first of
multiple figures, this should be set to TRUE which is its
default.  Otherwise, set this to FALSE in order to add
additional paths to the same figure.}
}
\value{
This returns 0.
}
\description{
This function assumes you have a path in dimension 3 and you have
found the projection for the portion under consideration, the
center for its projection and the circle (i.e., radius) for the
appropriate statistic.  Scales the path to keep it comparable to
the sphere and plots all this in your favorite color.  It can be
called repeatedly to add additional paths in different colors.
}
\examples{
plotPathProjectionCenterAndCircle(path=straight_path,
                                 projection=straight_path_projection,
                                 center=straight_path_center,
                                 radius=straight_path_radius,
                                 color='red',
                                 newFigure=TRUE)
}
