% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/globals.R
\name{TileDBArray-globals}
\alias{TileDBArray-globals}
\alias{getTileDBPath}
\alias{setTileDBPath}
\alias{getTileDBAttr}
\alias{setTileDBAttr}
\alias{getTileDBDimType}
\alias{setTileDBDimType}
\alias{getTileDBExtent}
\alias{setTileDBExtent}
\alias{getTileDBContext}
\alias{setTileDBContext}
\alias{getTileDBCellOrder}
\alias{setTileDBCellOrder}
\alias{getTileDBTileOrder}
\alias{setTileDBTileOrder}
\alias{getTileDBCapacity}
\alias{setTileDBCapacity}
\title{TileDBArray global options}
\usage{
getTileDBPath()

setTileDBPath(path = NULL)

getTileDBAttr()

setTileDBAttr(attr = NULL)

getTileDBDimType()

setTileDBDimType(dimtype = NULL)

getTileDBExtent()

setTileDBExtent(extent = NULL)

getTileDBContext()

setTileDBContext(context = NULL)

getTileDBCellOrder()

setTileDBCellOrder(cellorder = NULL)

getTileDBTileOrder()

setTileDBTileOrder(tileorder = NULL)

getTileDBCapacity()

setTileDBCapacity(capacity = NULL)
}
\arguments{
\item{path}{String containing a path to a TileDB backend.}

\item{attr}{String containing the name of a TileDB attribute.}

\item{dimtype}{String specifying the TileDB datatype to use for the dimensions.}

\item{extent}{Integer scalar specifying the tile extent for all dimensions.
Alternatively, an integer vector of length equal to the number of dimensions,
specifying a different extent for each dimension in the array to be created.}

\item{context}{A TileDB context object, see \code{\link{tiledb_ctx}} for an example.}

\item{cellorder}{String specifying the desired cell order.}

\item{tileorder}{String specifying the desired tile order.}

\item{capacity}{Integer scalar specifying the data tile capacity for sparse arrays.}
}
\value{
All of the getter functions return the current global value,
or a default value if the former is \code{NULL}:
\itemize{
\item \code{path} defaults to a temporary file in \code{\link{tempdir}}.
\item \code{attr} defaults to \code{"x"}.
\item \code{dimtype} defaults to \code{"INT32"}.
\item \code{extent} defaults to \code{100L}.
\item \code{cellorder} defaults to \code{"COL_MAJOR"}.
\item \code{tileorder} defaults to \code{"COL_MAJOR"}.
\item \code{capacity} defaults to \code{10000L}.
\item \code{context} defaults to the value of \code{\link{tiledb_ctx}()}.
}

All setter functions change the global value and return \code{NULL} invisibly.
}
\description{
Global options for writing TileDBArray backends,
intended for parameters that cannot be automatically derived from the data.
}
\examples{
\dontshow{old <- getTileDBPath()}

setTileDBPath("my_local_dir")
getTileDBPath()

\dontshow{setTileDBPath(old)}

}
\seealso{
\code{\link{writeTileDBArray}}, where these functions are most often used.
}
\author{
Aaron Lun
}
