% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/singlegeneplot.R
\name{singlegeneplot}
\alias{singlegeneplot}
\title{singlegeneplot}
\usage{
singlegeneplot(geneexpr, TSCANorder, cell_size = 2)
}
\arguments{
\item{geneexpr}{The gene expression values. Names should agree with the pseudotime information.}

\item{TSCANorder}{The output of function \code{\link{TSCANorder}}.}

\item{cell_size}{Size of cells in the plot.}
}
\value{
ggplot2 object.
}
\description{
plot expression values of individual genes against pseudotime axis
}
\details{
This function plots the expression values of individual genes against given pseudotime
}
\examples{
data(lpsdata)
procdata <- preprocess(lpsdata)
lpsmclust <- exprmclust(procdata)
lpsorder <- TSCANorder(lpsmclust,orderonly=FALSE,flip=TRUE)
#Choose STAT1 gene expression to plot
STAT2expr <- log2(lpsdata["STAT2",]+1)
singlegeneplot(STAT2expr, lpsorder)
}
\author{
Zhicheng Ji, Hongkai Ji <zji4@zji4.edu>
}
