% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/orderscore.R
\name{orderscore}
\alias{orderscore}
\title{orderscore}
\usage{
orderscore(subpopulation, orders)
}
\arguments{
\item{subpopulation}{Data frame with two columns. First column: cell names. Second column: sub-population codes.}

\item{orders}{A list with various length containing pseudotime orderings.}
}
\value{
a numeric vector of calculated POS.
}
\description{
Calculate pseudotemporal ordering scores for orders
}
\details{
This function calculates pseudotemporal ordering scores (POS) based on the sub-population information and order information given by users.
Cells should come from at least two cell sub-populations. These sub-population should be coded as 0,1,2,...
}
\examples{
data(lpsdata)
procdata <- preprocess(lpsdata)
subpopulation <- data.frame(cell = colnames(procdata), sub = ifelse(grepl("Unstimulated",colnames(procdata)),0,1), stringsAsFactors = FALSE)
lpsmclust <- exprmclust(procdata)
#Comparing default TSCAN ordering and tuned TSCAN ordering
order1 <- TSCANorder(lpsmclust)
order2 <- TSCANorder(lpsmclust, c(1,2,3))
orders <- list(order1,order2)
orderscore(subpopulation, orders)
}
\author{
Zhicheng Ji, Hongkai Ji <zji4@zji4.edu>
}
