% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TSCANorder.R
\name{TSCANorder}
\alias{TSCANorder}
\title{TSCANorder}
\usage{
TSCANorder(mclustobj, MSTorder = NULL, orderonly = T, flip = F, listbranch = F)
}
\arguments{
\item{mclustobj}{The exact output of the \code{\link{exprmclust}} function.}

\item{MSTorder}{A numeric vector specifying the order of clusters.}

\item{orderonly}{Only return the ordering. State or pseudotime information will not be returned}

\item{flip}{whether to flip the ordering}

\item{listbranch}{whether to list the ordering results of all possible branches in MST. Only works if MSTorder in NULL.}
}
\value{
if orderonly = F, a vector of ordered cell names. if orderonly = T, a data frame of ordered cell names, cell states and pseudotime.
}
\description{
Construct TSCAN order after exprmclust
}
\details{
This function takes the exact output of exprmclust function and construct TSCAN order by mapping all cells onto the path that connects cluster centers.
Users can also specify their own path.
}
\examples{
data(lpsdata)
procdata <- preprocess(lpsdata)
lpsmclust <- exprmclust(procdata)
TSCANorder(lpsmclust)
}
\author{
Zhicheng Ji, Hongkai Ji <zji4@zji4.edu>
}
