% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsa_curves.R
\name{TSA_compare_plot}
\alias{TSA_compare_plot}
\title{Compare TSA curves to control}
\usage{
TSA_compare_plot(
  tsa_data,
  control_condition,
  y = "Fluorescence",
  show_Tm = TRUE,
  title_by = "both",
  digits = 1,
  smoother = c("gam", "beta", "none"),
  smooth_conditions = TRUE,
  beta_shape = 3,
  beta_n_knots = NULL,
  beta_knots_frac = 0.12,
  use_natural = TRUE
)
}
\arguments{
\item{tsa_data}{a data frame that is merged and generated by
TSAR::merge_TSA(). If \code{y = 'RFU'}, tsa_data must also be
generated by TSAR::normalize_fluorescence. The Temperature column will be
rounded and the average & sd of each rounded temperature is calculated.}

\item{control_condition}{character string matching a Condition ID. Must be
equal to a value within tsa_data$condition_ID. See unique condition IDs
with \code{\link{condition_IDs}}.}

\item{y}{character string; c('Fluorescence', 'RFU').
When \code{y = 'Fluorescence'}, the original Fluorescence data from
TSAR::read_raw_data() is averaged. When \code{y = 'RFU'}, the average is
calculated by the rescaled fluorescence.}

\item{show_Tm}{logical; \code{show_Tm = TRUE} by default. When TRUE, the Tm
is displayed on the plot. When FALSE, the Tm is not added to the plot.}

\item{title_by}{character string; c("ligand", "protein", "both").
Automatically names the plots by the specified condition category.}

\item{digits}{integer; the number of decimal places to round for change in Tm
calculations displayed in the subtitle of each plot.}

\item{smoother}{character; one of \code{c("gam","beta","none")}.
Passed to \code{\link{TSA_average}} to select the aggregate smoother:
\code{"gam"} uses \pkg{mgcv}, \code{"beta"} uses a natural cubic spline
with Beta(a,a) interior knots centered at Tm, and \code{"none"} uses the
unsmoothed average. Default follows \code{TSA_average}.}

\item{smooth_conditions}{logical; \code{smooth_conditions = TRUE} by default.
Controls whether each non-control condition curve is drawn using smoothed
aggregates from \code{\link{TSA_average}}. When \code{TRUE}, the condition
overlay uses \code{avg_smooth} and the smoothed standard deviation bounds
(\code{sd_min_smooth}, \code{sd_max_smooth}) when available. When \code{FALSE},
the overlay uses the unsmoothed mean (\code{average}) and raw bounds
(\code{sd_min}, \code{sd_max}). The control curve remains smoothed.
(Passed as \code{avg_smooth} and \code{sd_smooth} to \code{TSA_average}.)}

\item{beta_shape}{numeric; shape parameter \eqn{a} for the Beta(a,a) knot
placement when \code{smoother = "beta"}. \code{beta_shape = 3} by default. Passed to \code{TSA_average}.}

\item{beta_n_knots}{integer or \code{NULL}; number of interior knots when
\code{smoother = "beta"}. If \code{NULL}, uses \code{beta_knots_frac}.
Passed to \code{TSA_average}.}

\item{beta_knots_frac}{numeric in (0,1); fraction of unique temperatures used
as interior knots when \code{smoother = "beta"} and \code{beta_n_knots}
is \code{NULL}. \code{beta_knots_frac = 0.008} by default. Passed to \code{TSA_average}.}

\item{use_natural}{logical; if TRUE (default) uses natural cubic spline
basis for the beta method. Passed to \code{TSA_average}.}
}
\value{
A \emph{named list} of ggplot objects. One plot per non-control
    condition is included, each overlaid against the control. A final plot for
    the control alone is appended and named \code{"Control: <control_condition>"}.
}
\description{
Generate a number of plots based on the input data to compare the average
and standard deviation (sd) of each unique condition to a specified
control condition. To see all conditions use \code{condition_IDs(tsa_data)}.
}
\examples{
data("example_tsar_data")
TSA_compare_plot(example_tsar_data,
    y = "Fluorescence",
    control_condition = "CA FL_DMSO",
    smoother = "beta",
    beta_shape = 4, 
    beta_knots_frac = 0.008
)
}
\seealso{
\code{\link{merge_TSA}} and \code{\link{normalize_fluorescence}}
    for preparing data. See \code{\link{TSA_average}} and
    \code{\link{get_legend}} for details on function parameters.
    See \code{\link{TSA_wells_plot}} for individual curves of the averaged
    conditions shown.

Other TSA Plots: 
\code{\link{TSA_boxplot}()},
\code{\link{TSA_wells_plot}()},
\code{\link{get_legend}()},
\code{\link{graph_tsar}()},
\code{\link{view_deriv}()}
}
\concept{TSA Plots}
