% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/screen.R
\name{screen}
\alias{screen}
\title{Screen raw curves}
\usage{
screen(raw_data, checkrange = NULL, checklist = NULL)
}
\arguments{
\item{raw_data}{input raw_data}

\item{checkrange}{list type input identifying range of wells to select.
For example, if viewing first 8 wells from row A to C is needed, one can
specify the row letters and column numbers like this:
\code{checkrange = c("A", "C", "1", "8")}}

\item{checklist}{use this parameter to view selected Wells with full
Well names. For example, \code{checklist = c('A01', 'D11')}}
}
\value{
returns a ggplot graph colors by well IDs
}
\description{
screens multiple wells of data and prepares to assist identification of
    corrupted wells and odd out behaviors
}
\examples{
data("qPCR_data1")
screen(qPCR_data1, checkrange = c("A", "C", "1", "12"))

}
\seealso{
Other data_preprocess: 
\code{\link{model_boltzmann}()},
\code{\link{model_fit}()},
\code{\link{model_gam}()},
\code{\link{normalize}()},
\code{\link{remove_raw}()},
\code{\link{run_boltzmann}()},
\code{\link{view_model}()},
\code{\link{weed_raw}()}
}
\concept{data_preprocess}
