% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_preprocess.R
\name{model_boltzmann}
\alias{model_boltzmann}
\title{Boltzmann Modeling on TSA data}
\usage{
model_boltzmann(norm_data)
}
\arguments{
\item{norm_data}{data frame input, preferably normalized using
\code{\link{normalize}}.}
}
\value{
dtaa frame containing gam model fitted values
}
\description{
Function finds fitted fluorescence values by imposing Boltzmann function.
}
\examples{
data("qPCR_data1")
A01 <- subset(qPCR_data1, Well.Position == "A01")
A01 <- normalize(A01)
model_boltzmann(A01)

}
\seealso{
Other data_preprocess: 
\code{\link{model_fit}()},
\code{\link{model_gam}()},
\code{\link{normalize}()},
\code{\link{remove_raw}()},
\code{\link{run_boltzmann}()},
\code{\link{screen}()},
\code{\link{view_model}()},
\code{\link{weed_raw}()}
}
\concept{data_preprocess}
