% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_preprocess.R
\name{model_beta}
\alias{model_beta}
\title{Beta-knot natural cubic spline model (Tm-centered via numerical_Tm)}
\usage{
model_beta(
  norm_data,
  x,
  y,
  beta_shape = 4,
  beta_knots_frac = 0.008,
  beta_n_knots = NULL,
  use_natural = TRUE
)
}
\arguments{
\item{norm_data}{data.frame with numeric columns x and y (normalized).}

\item{x, y}{character; names of the predictor and response columns.}

\item{beta_shape}{numeric > 0; Beta(a,a) shape parameter. Default 4.}

\item{beta_knots_frac}{numeric in (0,1); fraction of unique x used for
interior knots if \code{beta_n_knots} is NULL. Default 0.008.}

\item{beta_n_knots}{integer or NULL; overrides fraction when provided.}

\item{use_natural}{logical; if TRUE (default) uses \code{splines::ns()},
else \code{splines::bs(..., degree = 3)}.}
}
\value{
\code{"lm"} fit with spline basis; attributes store knots and settings.
}
\description{
Fits a natural cubic spline to \code{y} as a function of \code{x} using
interior knots at Beta(a,a) quantiles, centered at the numerically estimated
Tm from \code{\link{numerical_Tm}}.
}
