% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summaryTSA.R
\name{condition_IDs}
\alias{condition_IDs}
\title{TSAR Condition IDs}
\usage{
condition_IDs(analysis_data, n = FALSE)
}
\arguments{
\item{analysis_data}{a data frame that is unmerged and generated by
TSAR::read_analysis() or a merged TSA data frame generated by
TSAR::merge_TSA(). Data frames require a column named 'condition_ID'.}

\item{n}{logical value; \code{n = FALSE} by default. When TRUE, a numeric
value of unique IDs is returned. When FALSE, a character vector of unique
IDs are returned.}
}
\value{
Either a character vector of condition_IDs or a numeric value.
}
\description{
This function is used to extract information of the condition IDs from a
    loaded TSA Analysis Data file. Condition IDs are automatically generated
    by the read_analysis function in the automated workflow. This returns
    either a character vector of unique IDs present or a numeric value of the
    number of unique IDs.
}
\examples{
data("example_tsar_data")
condition_IDs(example_tsar_data)

}
\seealso{
\code{\link{merge_TSA}} and \code{\link{read_analysis}}
for preparing input.

Other TSA Summary Functions: 
\code{\link{TSA_ligands}()},
\code{\link{TSA_proteins}()},
\code{\link{well_IDs}()}
}
\concept{TSA Summary Functions}
