% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsa_curves.R
\name{TSA_boxplot}
\alias{TSA_boxplot}
\title{TSA Box Plot}
\usage{
TSA_boxplot(
  tsa_data,
  control_condition = NA,
  color_by = "Protein",
  label_by = "Ligand",
  separate_legend = TRUE
)
}
\arguments{
\item{tsa_data}{a data frame that is merged and generated by
TSAR::merge_TSA(). If \code{y = 'RFU'}, tsa_data must also be
generated by TSAR::normalize_fluorescence. The Temperature column will be
rounded and the average & sd of each rounded temperature is calculated.}

\item{control_condition}{Either a condition_ID or NA; NA by default.
When a valid Condition ID is provided, a vertical line appears at the
average Tm for the specified condition. When NA, this is skipped.}

\item{color_by}{character string, either c("Ligand", "Protein").
The condition category to color the boxes within the box
plot for comparison. This is represented in the legend.
Set to NA to skip.}

\item{label_by}{character string, either c("Ligand", "Protein").
The condition category to group the boxes within the box
plot. This is represented in the axis. Set to NA to skip.}

\item{separate_legend}{logical; \code{separate_legend = TRUE} by default.
When TRUE, the ggplot2 legend is separated from the TSA curve.
This is to help with readability. One ggplot is returned when FALSE.}
}
\value{
by default, two ggplots are returned: one TSA curve and one key.
    When \code{separate_legend = FALSE} one ggplot is returned.
}
\description{
Generates a box and whiskers plot for each condition specified. This
    is used to compare Tm values between the data set.
    See \code{\link{Tm_difference}} for details.
}
\examples{
data("example_tsar_data")
TSA_boxplot(example_tsar_data,
    color_by = "Protein",
    label_by = "Ligand", separate_legend = FALSE
)
}
\seealso{
\code{\link{merge_TSA}}
    for preparing data. See \code{\link{Tm_difference}} and
    \code{\link{get_legend}} for details on function parameters.

Other TSA Plots: 
\code{\link{TSA_compare_plot}()},
\code{\link{TSA_wells_plot}()},
\code{\link{get_legend}()},
\code{\link{graph_tsar}()},
\code{\link{view_deriv}()}
}
\concept{TSA Plots}
