% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/editing.functions.R
\name{join.types}
\alias{join.types}
\title{join.types}
\usage{
join.types(x, ..., new.type = "new.type", new.color = "khaki", silent = FALSE)
}
\arguments{
\item{x}{A TRONCO compliant dataset.}

\item{...}{type to merge}

\item{new.type}{label for the new type to create}

\item{new.color}{color for the new type to create}

\item{silent}{A parameter to disable/enable verbose messages.}
}
\value{
A TRONCO compliant dataset.
}
\description{
For an input dataset merge all the events of two or more distincit types
(e.g., say that missense and indel mutations are events
of a unique "mutation" type)
}
\examples{
data(test_dataset_no_hypos)
join.types(test_dataset_no_hypos, 'ins_del', 'missense_point_mutations')
join.types(test_dataset_no_hypos, 'ins_del',
     'missense_point_mutations', new.type='mut', new.color='green')

}
