% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loading.R
\name{import.GISTIC}
\alias{import.GISTIC}
\title{import.GISTIC}
\usage{
import.GISTIC(
  x,
  filter.genes = NULL,
  filter.samples = NULL,
  silent = FALSE,
  trim = TRUE,
  rna.seq.data = NULL,
  rna.seq.up = NULL,
  rna.seq.down = NULL
)
}
\arguments{
\item{x}{Either a dataframe or a filename}

\item{filter.genes}{A list of genes}

\item{filter.samples}{A list of samples}

\item{silent}{A parameter to disable/enable verbose messages.}

\item{trim}{Remove the events without occurrence}

\item{rna.seq.data}{Either a dataframe or a filename}

\item{rna.seq.up}{TODO}

\item{rna.seq.down}{TODO}
}
\value{
A TRONCO compliant representation of the input CNAs.
}
\description{
Transform GISTIC scores for CNAs in a TRONCO compliant object. Input can be either a matrix, with columns
for each altered gene and rows for each sample; in this case colnames/rownames mut be provided. If input
is a character an attempt to load a table from file is performed. In this case the input table format
should be constitent with TCGA data for focal CNA; there should hence be: one column for each sample,
one row for each gene, a column Hugo_Symbol with every gene name and a column Entrez_Gene_Id with every
 gene\'s Entrez ID. A valid GISTIC score should be any value of: "Homozygous Loss" (-2), "Heterozygous
 Loss" (-1), "Low-level Gain" (+1), "High-level Gain" (+2). For details and examples 
regarding the loading functions provided by the package we refer to the Vignette Section 3.
}
\examples{
data(crc_gistic)
gistic = import.GISTIC(crc_gistic)

}
