% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.functions.R
\name{as.pathway}
\alias{as.pathway}
\title{as.pathway}
\usage{
as.pathway(
  x,
  pathway.genes,
  pathway.name,
  pathway.color = "yellow",
  aggregate.pathway = TRUE,
  silent = FALSE
)
}
\arguments{
\item{x}{A TRONCO compliant dataset.}

\item{pathway.genes}{Gene (symbols) involved in the pathway.}

\item{pathway.name}{Pathway name for visualization.}

\item{pathway.color}{Pathway color for visualization.}

\item{aggregate.pathway}{If TRUE drop the events for the genes in the pathway.}

\item{silent}{A parameter to disable/enable verbose messages.}
}
\value{
Extract the subset of events for genes which are part of a pathway.
}
\description{
Given a cohort and a pathway, return the cohort with events restricted to genes 
involved in the pathway. This might contain a new 'pathway' genotype with an alteration mark if
any of the involved genes are altered.
}
\examples{
data(test_dataset)
p = as.pathway(test_dataset, c('ASXL1', 'TET2'), 'test_pathway')

}
