% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.functions.R
\name{as.gene}
\alias{as.gene}
\title{as.gene}
\usage{
as.gene(x, genes, types = NA)
}
\arguments{
\item{x}{A TRONCO compliant dataset.}

\item{genes}{The genes to consider, if NA all available genes are used.}

\item{types}{The types of events to consider, if NA all available types are used.}
}
\value{
A matrix, subset of \code{as.genotypes(x)} with colnames substituted  with events' types.
}
\description{
Return the genotypes for a certain set of genes and type of events. Input 'x' should be a
TRONCO compliant dataset - see \code{is.compliant}. In this case column names are substituted
with events' types.
}
\examples{
data(test_dataset)
as.gene(test_dataset, genes = c('EZH2', 'ASXL1'))

}
