% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.functions.R
\name{as.events}
\alias{as.events}
\title{as.events}
\usage{
as.events(x, genes = NA, types = NA, keysToNames = FALSE)
}
\arguments{
\item{x}{A TRONCO compliant dataset.}

\item{genes}{The genes to consider, if NA all available genes are used.}

\item{types}{The types of events to consider, if NA all available types are used.}

\item{keysToNames}{If TRUE return a list of mnemonic name composed by type + gene}
}
\value{
A matrix with 2 columns (event type, gene name) for the events found.
}
\description{
Return all events involving certain genes and of a certain type in 'x', which should be a
TRONCO compliant dataset - see \code{is.compliant}.
}
\examples{
data(test_dataset)
as.events(test_dataset)
as.events(test_dataset, types='ins_del')
as.events(test_dataset, genes = 'TET2')
as.events(test_dataset, types='Missing')

}
