% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tppDefaultTheme.R
\name{tppDefaultTheme}
\alias{tppDefaultTheme}
\title{Default ggplot theme for melting curve plots.}
\usage{
tppDefaultTheme()
}
\value{
ggplot theme with default settings for melting plot appearance.
}
\description{
Default theme to be passed to the gplots produced by the TPP package.
}
\details{
Internally, the theme is used as an argument for the function 
\code{ggplot2::theme_set} in order specify the appearance of the melting curve plots.

The specified plot properties include bold font and increased font size for axis labels and title, as well as a 90 degree angle for y axis labels.
}
\examples{
# Import data:
data(hdacTR_smallExample)
tpptrData <- tpptrImport(configTable=hdacTR_config, data=hdacTR_data)
# Obtain template with default settings:
normRequirements <- tpptrDefaultNormReqs()
print(normRequirements)
# Relax filter on the 10th fold change column for 
# normalization set production:
normRequirements$fcRequirements[3,3] <- 0.25
# Perform normalization:
tpptrNorm <- tpptrNormalize(data=tpptrData, normReqs=)
}
