% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tpp2dNormalize.R
\name{tpp2dNormalize}
\alias{tpp2dNormalize}
\title{Median normalization of protein fold changes of 2D-TPP data}
\usage{
tpp2dNormalize(configTable = NULL, data, fcStr = NULL)
}
\arguments{
\item{configTable}{DEPRECATED}

\item{data}{data frame that contains the data for the 2D-TPP experiment}

\item{fcStr}{DEPRECATED}
}
\value{
A dataframe identical to the input dataframe except that the columns containing the
  fold change values have been normalized by their median.
}
\description{
Normalizes fold changes retrieved from 2D-TPP experiment by dividing by the median fold
  change
}
\examples{
# Preparation:
data(panobinostat_2DTPP_smallExample)

# Import data:
datIn <- tpp2dImport(configTable = panobinostat_2DTPP_config,
                      data = panobinostat_2DTPP_data,
                      idVar = "representative",
                      addCol = "clustername",
                      intensityStr = "sumionarea_protein_",
                      nonZeroCols = "qusm")

# Compute fold changes:
datFC <- tpp2dComputeFoldChanges(data = datIn)

# Perform median normalization:
datNorm <- tpp2dNormalize(data = datFC)

# View updated attributes. Now contain field 'fcStrNorm' indicating prefix
# of the fold change columns after normalization.
attr(datNorm, "importSettings")["fcStrNorm"]
  
}
