% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tpp2dCreateTPPTRreference.R
\name{tpp2dCreateTPPTRreference}
\alias{tpp2dCreateTPPTRreference}
\title{Create TPP-TR reference for 2D-TPP experiment}
\usage{
tpp2dCreateTPPTRreference(
  trConfigTable = NULL,
  trDat = NULL,
  resultPath = NULL,
  outputName = NULL,
  createFCboxplots = FALSE,
  idVar = "gene_name",
  fcStr = "rel_fc_",
  qualColName = "qupm",
  normalize = TRUE
)
}
\arguments{
\item{trConfigTable}{config file for a reference TR dataset}

\item{trDat}{list of dataframes, containing fold change measurements and 
additional annotation columns to be imported. Can be used instead of 
specifying the file path in the \code{configTable} argument.}

\item{resultPath}{character string containing a valid system path to which folder output files 
will be written}

\item{outputName}{character string which will be used as name of the output folder}

\item{createFCboxplots}{boolean flag indicating whether quality control boxplots are to be plotted}

\item{idVar}{character string indicating which column of the data table contains the unique
protein ids}

\item{fcStr}{character string indicating which columns contain fold changes}

\item{qualColName}{character string indicating which column contain protein 
identification quality measures}

\item{normalize}{boolean argument stating whether the data should be normalized or not}
}
\value{
A TPP-TR reference object for a certain cell line with different supporting files in a 
 desired output directory. The main object which is of interest for further analysis is the 
 \code{trRefData.RData} file. This is the file to which a referencing system path has to be 
 indicated when a function as \code{\link{tpp2dSplineFitAndTest}}
 require to input a TPP-TR reference object. 
 The RData file consists of list carrying four different items: \enumerate{ \item tppCfgTable: 
 the TPP-TR configtable which was used for generating this object \item sumResTable a list of
 two elements 1. detail: the exact result data from the TR analysis and 2. summary. a summary
 of the analyzed TR data comprising the median and standard deviation values of the measurements
 at the different temperatures (encoded by the isobaric labels) \item temperatures a table listing
 the temperatures which were used in the TR experiment in the different replicates \item lblsByTemp 
 a table matching each temperature to an isobaric label}
}
\description{
Performs a reference analysis of a TPP-TR experiment and generates boxplots for
 the distribution of fold changes at the different temperatures if desired.
}
