% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tpp2dCreateDRplots.R
\name{tpp2dCreateDRplots}
\alias{tpp2dCreateDRplots}
\title{Create dose response curve plots for 2D-TPP data}
\usage{
tpp2dCreateDRplots(
  data = NULL,
  type = "all",
  verbose = FALSE,
  paletteName = "Spectral"
)
}
\arguments{
\item{data}{the data that should be plotted.}

\item{type}{string defining which curves to display (see details).}

\item{verbose}{boolean variable stating whether a print description of 
problems/success for plotting of each protein should be printed.}

\item{paletteName}{color palette (see details).}
}
\value{
A list of successfully generated plot objects of class 
        \code{'ggplot'}
}
\description{
Generates a list of dose response curve plots per protein and 
temperature point.
}
\details{
\code{data} is a data frame in wide table format returned by function 
\code{\link{tpp2dCurveFit}}. Its attributes contain information about the 
experiment names, temperatures, isobaric labels, as well as instructions on 
how to find the relevant columns in the wide table.

\code{type} defines which curves to display per plot. Possible values are:
  \itemize{ 
  \item{"all": Create one plot per protein. This plot simultaneously 
  displays the curves for all available temperatures for this protein 
  (the default).} 
  \item{"good": Create one plot per protein. This plot displays all
  dose response curves with a high goodness-of-fit.
  Choose this option to save runtime by focusing only on the reliable fits.} 
  \item{"single": Create one separate plot per protein and temperature. 
  This plot displays all dose response curves with a high goodness-of-fit.} 
  }
 
 \code{paletteName} specifies the color palette to be used by the \code{\link{brewer.pal}} 
function from the \code{RColorBrewer} package to assign a separate color to 
each concentration.
}
\examples{
data(panobinostat_2DTPP_smallExample)

# Import data:
datIn <- tpp2dImport(configTable = panobinostat_2DTPP_config,
                      data = panobinostat_2DTPP_data,
                      idVar = "representative",
                      addCol = "clustername",
                      intensityStr = "sumionarea_protein_",
                      nonZeroCols = "qusm")

# Compute fold changes:
fcData2d <- tpp2dComputeFoldChanges(data = datIn)
normData2d <- tpp2dNormalize(data = fcData2d)
ccr2dResults <- tpp2dCurveFit(data = normData2d)
allCurves <- tpp2dCreateDRplots(data = ccr2dResults, type = "all")
allCurves[["HDAC1"]]


}
\seealso{
\code{\link{tpp2dCurveFit}} \code{\link{brewer.pal}}
}
