% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/external_TMixClust.R
\name{get_time_series_df}
\alias{get_time_series_df}
\title{Extracts a time series data frame from a text file}
\usage{
get_time_series_df(data_file)
}
\arguments{
\item{data_file}{path to a tab-delimited text file containing the time series
data formatted such that each row contains a time-series represented by its
name (e.g. gene name, protein name, etc.) and the values at each time point.}
}
\value{
A data frame containing the time series
}
\description{
\code{get_time_series_df} creates a data frame containing time
series data from a file.
}
\examples{
# Load a simulated toy time-series data provided with the package
toy_data_file = system.file("extdata", "toy_time_series.txt",
package = "TMixClust")
toy_data= get_time_series_df(toy_data_file)

# Print the first lines of the resulting data frame
print(head(toy_data))

}
\references{
Golumbeanu M, Desfarges S, Hernandez C, Quadroni M, Rato S,
Mohammadi P, Telenti A, Beerenwinkel N, Ciuffi A. (2017) Dynamics of
Proteo-Transcriptomic Response to HIV-1 Infection.
}
\author{
Monica Golumbeanu, \email{monica.golumbeanu@bsse.ethz.ch}
}
