% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setup_lambert.R
\name{anchor_pmids}
\alias{anchor_pmids}
\title{check columns of a dataframe for numerical tokens of 7 or 8 digits
and create HTML anchors to pubmed.gov constituting a link to a PMID}
\usage{
anchor_pmids(dataframe)
}
\arguments{
\item{dataframe}{a data.frame instance}
}
\value{
data.frame with HTML anchors to pubmed.gov inserted where 7- or 8-digit numbers are found
}
\description{
check columns of a dataframe for numerical tokens of 7 or 8 digits
and create HTML anchors to pubmed.gov constituting a link to a PMID
}
\note{
The method of isolating putative PMIDs is peculiar to patterns found in
the comment fields of annotated TF table (supplemental table S1 found in
\url{https://www.cell.com/cms/10.1016/j.cell.2018.01.029/attachment/88c0eca1-66f9-4068-b02e-bd3d55144f79/mmc2.xlsx} of PMID 29425488).  When DT::datatable is called on the output
of this function with \code{escape=FALSE} the PMIDs will render as hyperlinks.
Note that column 1 is assumed to be an ENSEMBL ID which could have 7 or 8 digits but is handled differently
}
\examples{
litdf = data.frame(id="ENSG00000116819", a="Binds the same GCCTGAGGC sequence as the other AP-2s (PMID: 24789576)",
     stringsAsFactors=FALSE)
anchor_pmids(litdf)
}
