% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All-functions.R
\name{preprocessInputData}
\alias{preprocessInputData}
\title{Extracts data from a DESeqResults object or a data frame.}
\usage{
preprocessInputData(inputData, mode = "h2h")
}
\arguments{
\item{inputData}{DESeqResults object or data frame. In all cases
must include gene IDs. Data frame inputs should include 'pvalue' and
'log2FoldChange' as well.}

\item{mode}{Specify the organism used: 'h2h' for homo sapiens gene IDs,
'm2m' for mouse gene IDs, or 'm2h' to get the corresponding human gene
IDs from a mouse input.}
}
\value{
A table containing Entrez Gene IDs, Gene Symbols, LogFoldChange 
and p-val values (both raw p-value and fdr adjusted p-value), sorted by
log2FoldChange.
}
\description{
Function to extract Gene IDs, logFoldChange, and p-val
values from a DESeqResults object or data frame. Gene IDs are
translated to ENTREZ IDs, if possible, and the resultant data frame
is sorted according to decreasing log2(Fold Change). Translating
gene IDs from mouse to their equivalent human genes is available
using the variable "mode".
}
\examples{
data('hypoxia_DESeq',package='TFEA.ChIP')
preprocessInputData( hypoxia_DESeq )
}
