% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All-functions.R
\name{get_chip_index}
\alias{get_chip_index}
\title{Creates df containing accessions of ChIP-Seq datasets and TF.}
\usage{
get_chip_index(encodeFilter = FALSE, TFfilter = NULL)
}
\arguments{
\item{encodeFilter}{(Optional) If TRUE, only ENCODE ChIP-Seqs are
included in the index.}

\item{TFfilter}{(Optional) Transcription factors of interest.}
}
\value{
Data frame containig the accession ID and TF for every ChIP-Seq
experiment included in the metadata files.
}
\description{
Function to create a data frame containing the ChIP-Seq
dataset accession IDs and the transcription factor tested in each ChIP.
This index is used in functions like “contingency_matrix” and “GSEA_run”
as a filter to select specific ChIPs or transcription factors to run an
analysis.
}
\examples{
get_chip_index(encodeFilter = TRUE)
get_chip_index(TFfilter=c('SMAD2','SMAD4'))
}
