% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All-functions.R
\name{getCMstats}
\alias{getCMstats}
\title{Generate statistical parameters from contingency matrices}
\usage{
getCMstats(CM_list, chip_index = get_chip_index())
}
\arguments{
\item{CM_list}{A list of contingency matrices, typically from `contingency_matrix`.}

\item{chip_index}{A data frame with ChIP accession IDs and TFs from 
the `get_chip_index` function.
If not provided, the entire internal database is used.}
}
\value{
A data frame with the ChIP experiment ID, TF, p-value, odds-ratio, 
and other derived statistics.
}
\description{
This function computes Fisher's exact test for each matrix
in a list of contingency matrices (e.g., output from `contingency_matrix`).
It returns a data frame containing ChIP-Seq experiment accession IDs,
tested transcription factors, p-values, odds ratios, and adjusted values.
}
\examples{
data('Genes.Upreg', package = 'TFEA.ChIP')
CM_list_UP <- contingency_matrix(Genes.Upreg)
stats_mat_UP <- getCMstats(CM_list_UP)
}
