% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All-functions.R
\name{GSEA_EnrichmentScore}
\alias{GSEA_EnrichmentScore}
\title{Computes the weighted GSEA score of gene.set in gene.list.}
\usage{
GSEA_EnrichmentScore(
  gene.list,
  gene.set,
  weighted.score.type = 0,
  correl.vector = NULL
)
}
\arguments{
\item{gene.list}{The ordered gene list}

\item{gene.set}{A gene set, e.g. gene IDs corresponding to a ChIP-Seq
experiment's peaks.}

\item{weighted.score.type}{Type of score: weight:
0 (unweighted = Kolmogorov-Smirnov), 1 (weighted), and 2 (over-weighted)}

\item{correl.vector}{A vector with the correlations (such as signal to
noise scores) corresponding to the genes in the gene list}
}
\value{
list of:
ES: Enrichment score (real number between -1 and +1)
arg.ES: Location in gene.list where the peak running enrichment occurs
(peak of the 'mountain')
RES: Numerical vector containing the running enrichment score for all
locations in the gene list
tag.indicator: Binary vector indicating the location of the gene sets
(1's) in the gene list
}
\description{
Computes the weighted GSEA score of gene.set in gene.list.
}
\examples{
GSEA_EnrichmentScore(gene.list=c('3091','2034','405','55818'),
gene.set=c('2034','112399','405'))
}
